#Requires -Version 3.0
# =============================================================================================
# This script creates a html report of Active Directory user accounts with a changed primary group
# Version 1: query the local domain by the user account you're logged in with

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		20.03.2015
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$ReportTitle		= 'AD users with changed Primary Group Report'
$OutputFileName		= 'reports\Report-ChangedAdPrimaryGroup.html'

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)
. .\include\Export-HtmlReport.ps1

$Property = Get-ADUser -LDAPFilter "(&(!primaryGroupID=513))" -Property PrimaryGroup | Select Name,Enabled,PrimaryGroup
 
$FooterHash = [ordered]@{
							ScriptName		= $Script:MyInvocation.MyCommand.Name
							Author			= "thomas.franke@sepago.de"
							ScriptInvokedBy	= "$env:userdomain\$env:username"
							ExecutionDate	= Get-Date -Format yyyy-MM-dd
							ExecutionTime	= Get-Date -Format HH:mm
}
$FooterObject = New-Object -TypeName PSObject -Property $FooterHash

$InputObject =	@{
					Title		= "AD user objects with a changed primary group"
					Description = "The following list should only contain the guest user account."
					Object		= $Property
				},
				@{
					Object		= $FooterObject
				}
				
$InputObject | Export-HtmlReport -ReportTitle $ReportTitle -OutputFile $OutputFileName | Invoke-Item

Pop-Location
