#Requires -Version 3.0
# =============================================================================================
# This script shows how to open a connection to a VMware vCenter Server using the 
# -Menu parameter and how to read data, e.g. a list of the VMs hosted by this vCenter.

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		12.09.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

Connect-VIserver  -Menu

# Set language for current vcenter session
$ServiceInstance    = Get-View ServiceInstance
$SessionManager     = Get-View $ServiceInstance.Content.SessionManager
$SessionManager.SetLocale("en_US")

# Your workload goes here, e.g.:
Get-VM | Select Name,Version,NumCPU,MemoryMB | Format-Table

Disconnect-VIserver -Server * -Force -Confirm:$False
Pop-Location

Read-Host "`nPress <ENTER> to terminate script" | Out-Null
