#Requires -Version 3.0
# =============================================================================================
# This script shows how to read advanced ESXi host settings (here: 'Syslog.global.logHost').

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		12.09.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$VCenterServerName		= '<vCenter FQDN or IP>'
$UserName				= '<Domain\vCenter UserName>'

$AdvancedSettingName	= 'Syslog.global.logHost'

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

. .\include\Get-PSCredential.ps1
Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

$PSCredential = Get-PSCredential $UserName
Connect-VIserver -Server $VCenterServerName -Credential $PSCredential

# Set language for current vcenter session
$ServiceInstance    = Get-View ServiceInstance
$SessionManager     = Get-View $ServiceInstance.Content.SessionManager
$SessionManager.SetLocale("en_US")

Get-AdvancedSetting -Entity (Get-VMHost) -Name $AdvancedSettingName | Select Entity,Name,Value | Format-Table

Disconnect-VIserver -Server $VCenterServerName -Force -Confirm:$False
Pop-Location

Read-Host "`nPress <ENTER> to terminate script" | Out-Null
