#Requires -Version 3.0
# =============================================================================================
# This script creates a html report of vSphere cluster EVC mode and VM EVC status.

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		31.10.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$VCenterServerName		= '<vCenter FQDN or IP>'
$UserName				= '<Domain\vCenter UserName>'
	
$ReportTitle			= 'VMware Cluster EVC Mode'
$OutputFileName			= 'reports\Report-EvcMode.html'

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

. .\include\Export-HtmlReport.ps1
. .\include\Get-PSCredential.ps1
Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

$PSCredential = Get-PSCredential $UserName
Connect-VIserver -Server $VCenterServerName -Credential $PSCredential

# Set language for current vcenter session
$ServiceInstance    = Get-View ServiceInstance
$SessionManager     = Get-View $ServiceInstance.Content.SessionManager
$SessionManager.SetLocale("en_US")

$Cluster = Get-Cluster | Sort -Property Name

$Property1 = @()
$Cluster | ForEach {
	$Setting 	= [ordered]@{
							ClusterName		= $_.Name
							EvcMode			= $_.EvcMode
	}
	$Property1 += New-Object -TypeName PSObject -Property $Setting
}

$Property2 = @()
$Cluster | ForEach {
	$ClusterName = $_.Name
	$_ | Get-VM | Sort -Property Name | ForEach {
		$Setting 	= [ordered]@{
								ClusterName		= $ClusterName
								VmName			= $_.Name
								PowerState		= $_.PowerState
								EvcMode			= $_.extensiondata.runtime.MinRequiredEVCModeKey
		}
		$Property2 += New-Object -TypeName PSObject -Property $Setting
	}
}

$FooterHash = [ordered]@{
							ScriptName		= $Script:MyInvocation.MyCommand.Name
							Author			= "thomas.franke@sepago.de"
							ScriptInvokedBy	= "$env:userdomain\$env:username"
							ExecutionDate	= Get-Date -Format yyyy-MM-dd
							ExecutionTime	= Get-Date -Format HH:mm
}
$FooterObject = New-Object -TypeName PSObject -Property $FooterHash

$InputObject =	@{
					Title		= 'Cluster EVC Mode'
					Object		= $Property1
				},
				@{
					Title		= 'VM Guest EVC Status'
					Object		= $Property2
				},
				@{
					Object		= $FooterObject
				}

$InputObject | Export-HtmlReport -ReportTitle $ReportTitle -OutputFile $OutputFileName | Invoke-Item

Disconnect-VIserver -Server $VCenterServerName -Force -Confirm:$False
Pop-Location
