#Requires -Version 3.0
# =============================================================================================
# This script creates a html report of advanced ESXi host settings
# (here: 'Syslog.global.logHost').

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		12.09.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$VCenterServerName		= '<vCenter FQDN or IP>'
$UserName				= '<Domain\vCenter UserName>'

$AdvancedSettingName	= 'Syslog.global.logHost'

$ReportTitle			= 'ESXi Advanced Settings'
$OutputFileName			= 'reports\Report-VMHostAdvancedSettings.html'

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

. .\include\Export-HtmlReport.ps1
. .\include\Get-PSCredential.ps1
Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

$PSCredential = Get-PSCredential $UserName
Connect-VIserver -Server $VCenterServerName -Credential $PSCredential

# Set language for current vcenter session
$ServiceInstance    = Get-View ServiceInstance
$SessionManager     = Get-View $ServiceInstance.Content.SessionManager
$SessionManager.SetLocale("en_US")

$Property = Get-AdvancedSetting -Entity (Get-VMHost) -Name $AdvancedSettingName | Select Entity,Name,Value

$FooterHash = [ordered]@{
							ScriptName		= $Script:MyInvocation.MyCommand.Name
							Author			= "thomas.franke@sepago.de"
							ScriptInvokedBy	= "$env:userdomain\$env:username"
							ExecutionDate	= Get-Date -Format yyyy-MM-dd
							ExecutionTime	= Get-Date -Format HH:mm
}
$FooterObject = New-Object -TypeName PSObject -Property $FooterHash

$InputObject =	@{
					Title		= "vSphere Advanced Host Settings Report"
					Description	= "This report lists a selected ESXi Advanced Setting of all hosts."
					Object		= $Property
				},
				@{
					Object		= $FooterObject
				}

$InputObject | Export-HtmlReport -ReportTitle $ReportTitle -OutputFile $OutputFileName | Invoke-Item
	
Disconnect-VIserver -Server $VCenterServerName -Force -Confirm:$False
Pop-Location
