#Requires -Version 3.0
# =============================================================================================
# This script offers as a simple text menu to to choose a vSphere cluster
# and perform operations on the chosen cluster 

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		12.09.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$VCenterServerName		= '<vCenter FQDN or IP>'
$UserName				= '<Domain\vCenter UserName>'

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

. .\include\Get-PSCredential.ps1
Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

$PSCredential = Get-PSCredential $UserName
Connect-VIserver -Server $VCenterServerName -Credential $PSCredential

# Set language for current vcenter session
$ServiceInstance    = Get-View ServiceInstance
$SessionManager     = Get-View $ServiceInstance.Content.SessionManager
$SessionManager.SetLocale("en_US")

Write-Output "`nScript description"
Write-Output '=================='
# Your description goes here, e.g.:
Write-Output 'This script shows details about a chosen cluster'

[array]$VMCluster = Get-Cluster
If ($VMCluster)
{
	Write-Output "`n`nSelect a cluster from the list (by typing its number and pressing Enter):`n"
	Write-Output "[0] Cancel`n"
	For ($i=0; $i -lt $VMCluster.count; $i++)
	{
		Write-Output "[$($i+1)] $($VMCluster[$i].Name)"
	}
	Write-Output ''

	$ReadHost = Read-Host
	$VMClusterChoice = [int]$ReadHost - 1
	$ChosenVMCluster = $VMCluster[$VMClusterChoice]

	If ($VMClusterChoice -ne -1)
	{
		# Your workload goes here, e.g.:
		Write-Output $ChosenVMCluster
	}
	Else
	{
		Write-Output "`nCanceling script execution."
	}
}
Else
{
	Write-Output 'No cluster found!'
}

Disconnect-VIserver -Server $VCenterServerName -Force -Confirm:$False
Pop-Location

Read-Host "`nPress <ENTER> to terminate script" | Out-Null
