#Requires -Version 3.0
# =============================================================================================
# This script configures ESXi hosts with a list of  NTP servers.

# AUTHOR		Thomas Franke / sepago GmbH
# Blog			https://www.sepago.de/thomasf
# LASTEDIT		24.11.2014
# =============================================================================================

Set-StrictMode -Version Latest
Clear-Host

$VCenterServerName		= '<vCenter FQDN or IP>'
$UserName				= '<Domain\vCenter UserName>'

# Provide one or more NTP servers
$NtpServerList 			= @("<NTP-Server 1>", "<NTP-Server 2>")

# =============================================================================================

Push-Location $(Split-Path $Script:MyInvocation.MyCommand.Path)

. .\include\Get-PSCredential.ps1
Add-Pssnapin 'VMware.VimAutomation.Core' -ErrorAction SilentlyContinue

Try
{
	Disconnect-VIServer * -Force -Confirm:$False
}
Catch
{
	# nothing to do - no open connections!
}

$PSCredential = Get-PSCredential $UserName
Connect-VIserver -Server $VCenterServerName -Credential $PSCredential

$VMHosts	= Get-VMHost | Sort Name

$VMHosts | ForEach {
	$VMHost = $_
	$VMHost | Get-VmHostNtpServer | ForEach {
		Remove-VmHostNtpServer -NtpServer $_ -VMHost $VMHost -Confirm:$False
	}
	$NtpServerList | ForEach {
		$VMHost | Add-VmHostNtpServer $_ -Confirm:$False | Out-Null
	}
	$VMHost | Get-VmHostService | Where {$_.key -eq 'ntpd'} | Restart-VmHostService -Confirm:$False
}

Disconnect-VIserver -Server $VCenterServerName -Force -Confirm:$False
Pop-Location
